<?php

/**
 * Class DelegadoModel . Clase DelegadoModel.
 */
class DelegadoModel extends CI_Model


{
    const TABLE_NAME = 'Delegado';

    /**
     * DelegadoModel constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function createDelegado($email,$password_hash) {

    }

    /**
     * Obtener los datos de un delegado por su identificador primario (email)
     * pasado como parametro.
     * @param $email
     * @return Fila con los datos del delegado seleccionado por su email
     */
    public function getDelegado($email) {
        $sql = 'SELECT D.* from Delegado D WHERE D.email = ?';
        $query = $this -> db -> query($sql,array($email));
        return $query -> row();

    }

    public function setToken($email,$token) {
        $data = array('token' => $token);
        $this -> db -> where("email",$email);
        $this -> db -> update(self::TABLE_NAME,$data);


    }

    /**
     * Cambiar la contraseña del delegado
     * @param $password nueva contraseña
     * @param $email Identificador del delegado
     */
    public function setPassword($password, $email) {
        $data = array(
            'password' => $password
        );
        $this -> db -> where('email',$email);
        $this -> db -> update(self::TABLE_NAME,$data);
    }
    /**
     * Comprueba si el token pasado como parametro es igual al almacenado en
     * base de datos
     * @param $token
     * @param $email
     * @return bool
     */
    public function validateToken($token, $email) {
        $sql = 'SELECT D.token FROM Delegado D WHERE email = ?';
        $query = $this -> db -> query($sql,array($email));
        return $token == $query -> row() -> token;
    }

    /**
     * Funcion que verifica que la contraseña que esta almacenada en base de datos en formato HASH BYCRYPT es
     * igual a la pasada por parametro
     * @param $email Identificador del delegado
     * @param $password Contraseña a verificar
     * @return bool retorna true en caso de que coincidan, false en caso contrario
     */
    public function validatePassword($email,$password) {

        $this -> db -> select ('password');
        $this -> db -> where ('email',$email);
        $query = $this -> db -> get(self::TABLE_NAME);
        $password_hash = $query -> result()[0] -> password;
        return password_verify($password,$password_hash);
    }

    /**
     * Funcion que retorna si existe email en el delegado
     * @param $email Identificador del delegado
     * @return bool true en caso de que exista, false en caso contrario
     */
    public function existsEmail($email) {
        $sql = 'SELECT * FROM Delegado D WHERE D.email = ?';
        $query =  $this -> db -> query($sql,array($email));

        return $query->num_rows() != 0;
    }

}